/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import twilightforest.TFConfig;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFPortalBlock;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFLandmark;
import twilightforest.item.BrittleFlaskItem;
import twilightforest.network.MissingAdvancementToastPacket;
import twilightforest.network.StructureProtectionClearPacket;
import twilightforest.network.StructureProtectionPacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.util.PlayerHelper;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;
import twilightforest.world.registration.TFGenerationSettings;

@Mod.EventBusSubscriber(modid="twilightforest")
public class TFTickHandler {
    private static final Component PORTAL_UNWORTHY = Component.m_237115_((String)"twilightforest.ui.portal.unworthy");

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        Player eventPlayer = event.player;
        if (!(eventPlayer instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)eventPlayer;
        Level level = player.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        if (!((Boolean)TFConfig.COMMON_CONFIG.disablePortalCreation.get()).booleanValue() && event.phase == TickEvent.Phase.END && player.f_19797_ % ((Boolean)TFConfig.COMMON_CONFIG.checkPortalDestination.get() != false ? 100 : 20) == 0) {
            if (((Boolean)TFConfig.COMMON_CONFIG.adminOnlyPortals.get()).booleanValue()) {
                if (world.m_7654_().m_129944_(player.m_36316_()) != 0) {
                    TFTickHandler.checkForPortalCreation(player, (Level)world, 4.0f);
                }
            } else {
                TFTickHandler.checkForPortalCreation(player, (Level)world, 32.0f);
            }
        }
        if (event.phase == TickEvent.Phase.END && player.f_19797_ % 20 == 0) {
            BrittleFlaskItem.ticker();
        }
        if (event.phase == TickEvent.Phase.END && player.f_19797_ % 20 == 0 && TFGenerationSettings.isProgressionEnforced((Level)world) && TFGenerationSettings.usesTwilightChunkGenerator(world) && !player.m_7500_() && !player.m_5833_()) {
            TFGenerationSettings.enforceBiomeProgression((Player)player, (Level)world);
        }
        if (event.phase == TickEvent.Phase.END && player.f_19797_ % 100 == 0 && TFGenerationSettings.isProgressionEnforced((Level)world) && TFGenerationSettings.usesTwilightChunkGenerator(world)) {
            if (player.m_7500_() || player.m_5833_()) {
                TFTickHandler.sendAllClearPacket((Level)world, (Player)player);
            } else {
                TFTickHandler.checkForLockedStructuresSendPacket((Player)player, (Level)world);
            }
        }
    }

    private static void sendStructureProtectionPacket(Level world, Player player, BoundingBox sbb) {
        if (player instanceof ServerPlayer) {
            TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new StructureProtectionPacket(sbb));
        }
    }

    private static void sendAllClearPacket(Level world, Player player) {
        if (player instanceof ServerPlayer) {
            TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new StructureProtectionClearPacket());
        }
    }

    private static boolean checkForLockedStructuresSendPacket(Player player, Level world) {
        ChunkGeneratorTwilight chunkGenerator = WorldUtil.getChunkGenerator((LevelAccessor)world);
        if (chunkGenerator == null) {
            return false;
        }
        return TFGenerationSettings.locateTFStructureInRange((WorldGenLevel)((ServerLevel)world), player.m_20183_(), 100).map(structure -> {
            BoundingBox fullSBB = structure.m_73601_();
            Vec3i center = BoundingBoxUtils.getCenter(fullSBB);
            TFLandmark nearFeature = LegacyLandmarkPlacements.getFeatureForRegionPos(center.m_123341_(), center.m_123343_(), (WorldGenLevel)((ServerLevel)world));
            if (!nearFeature.hasProtectionAura || nearFeature.doesPlayerHaveRequiredAdvancements(player)) {
                TFTickHandler.sendAllClearPacket(world, player);
                return false;
            }
            TFTickHandler.sendStructureProtectionPacket(world, player, fullSBB);
            return true;
        }).orElse(false);
    }

    private static void checkForPortalCreation(ServerPlayer player, Level world, float rangeToCheck) {
        if (world.m_46472_().m_135782_().equals((Object)new ResourceLocation((String)TFConfig.COMMON_CONFIG.originDimension.get())) || TFGenerationSettings.isTwilightPortalDestination(world) || ((Boolean)TFConfig.COMMON_CONFIG.allowPortalsInOtherDimensions.get()).booleanValue()) {
            Advancement requirement;
            List itemList = world.m_45976_(ItemEntity.class, player.m_20191_().m_82400_((double)rangeToCheck));
            ItemEntity qualified = null;
            for (ItemEntity entityItem : itemList) {
                if (!entityItem.m_32055_().m_204117_(ItemTagGenerator.PORTAL_ACTIVATOR) || !((TFPortalBlock)((Object)TFBlocks.TWILIGHT_PORTAL.get())).canFormPortal(world.m_8055_(entityItem.m_20183_())) || !Objects.equals(entityItem.m_32057_(), player.m_20148_())) continue;
                qualified = entityItem;
                break;
            }
            if (qualified == null) {
                return;
            }
            if (!(player.m_7500_() || player.m_5833_() || TFConfig.getPortalLockingAdvancement((Player)player) == null || (requirement = PlayerHelper.getAdvancement((Player)player, Objects.requireNonNull(TFConfig.getPortalLockingAdvancement((Player)player)))) == null || PlayerHelper.doesPlayerHaveRequiredAdvancement((Player)player, requirement))) {
                player.m_5661_(PORTAL_UNWORTHY, true);
                if (!TFPortalBlock.isPlayerNotifiedOfRequirement(player)) {
                    DisplayInfo info = requirement.m_138320_();
                    TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)(info == null ? new MissingAdvancementToastPacket((Component)Component.m_237115_((String)".ui.advancement.no_title"), new ItemStack((ItemLike)TFBlocks.TWILIGHT_PORTAL_MINIATURE_STRUCTURE.get())) : new MissingAdvancementToastPacket(info.m_14977_(), info.m_14990_())));
                    TFPortalBlock.playerNotifiedOfRequirement(player);
                }
                return;
            }
            Random rand = new Random();
            for (int i = 0; i < 2; ++i) {
                double vx = rand.nextGaussian() * 0.02;
                double vy = rand.nextGaussian() * 0.02;
                double vz = rand.nextGaussian() * 0.02;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123806_, qualified.m_20185_(), qualified.m_20186_() + 0.2, qualified.m_20189_(), vx, vy, vz);
            }
            if (((TFPortalBlock)((Object)TFBlocks.TWILIGHT_PORTAL.get())).tryToCreatePortal(world, qualified.m_20183_(), qualified, (Player)player)) {
                TFAdvancements.MADE_TF_PORTAL.trigger(player);
            }
        }
    }
}

